/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.builder;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.builder.AbstractBuildPath;
import com.aptana.editor.php.internal.builder.FolderFilteringManager;
import com.aptana.editor.php.internal.builder.LocalDirectory;
import com.aptana.editor.php.internal.builder.LocalModule;
import com.aptana.editor.php.internal.builder.PHPLocalModuleFactory;
import com.aptana.editor.php.internal.core.builder.IBuildPathResource;
import com.aptana.editor.php.internal.core.builder.IDirectory;
import com.aptana.editor.php.internal.core.builder.IModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public class ProjectBuildPath
extends AbstractBuildPath {
    private IProject project;
    private Map<IFile, IModule> modules = new HashMap<IFile, IModule>();
    private Map<IContainer, IDirectory> directories = new HashMap<IContainer, IDirectory>();
    private IResourceChangeListener workspaceListener;

    public ProjectBuildPath(IProject project) {
        this.project = project;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.indexLocalResources();
        this.bindListeners(workspace);
    }

    public List<IModule> getModules() {
        ArrayList<IModule> result = new ArrayList<IModule>();
        result.addAll(this.modules.values());
        return result;
    }

    public void close() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null && this.workspaceListener != null) {
            workspace.removeResourceChangeListener(this.workspaceListener);
        }
    }

    public IModule getModule(Object moduleResource) {
        IFile f;
        if (!(moduleResource instanceof IFile)) {
            return null;
        }
        IModule module = this.modules.get(moduleResource);
        if (module == null && (f = (IFile)moduleResource).getProject().equals((Object)this.project)) {
            IModule module2 = PHPLocalModuleFactory.getModule((IResource)f, this);
            if (module2 != null) {
                this.modules.put(f, module2);
            }
            return module2;
        }
        return module;
    }

    public IDirectory getDirectory(Object directoryResource) {
        if (directoryResource instanceof IProject && this.project.equals(directoryResource)) {
            if (!((IProject)directoryResource).isAccessible()) {
                return null;
            }
            return new LocalDirectory((IContainer)this.project, this);
        }
        if (!(directoryResource instanceof IFolder)) {
            return null;
        }
        return this.directories.get(directoryResource);
    }

    public IPath getResourcePath(IBuildPathResource resource) {
        if (resource instanceof LocalModule) {
            IFile moduleFile = ((LocalModule)resource).getFile();
            if (!this.project.equals((Object)moduleFile.getProject())) {
                return null;
            }
            return moduleFile.getProjectRelativePath().makeAbsolute();
        }
        if (resource instanceof LocalDirectory) {
            IContainer fld = ((LocalDirectory)resource).getContainer();
            if (!this.project.equals((Object)fld.getProject())) {
                return null;
            }
            return fld.getProjectRelativePath().makeAbsolute();
        }
        return null;
    }

    public IModule getModuleByPath(IPath path) {
        IFile resource;
        block3: {
            try {
                resource = this.project.getFile(path);
                if (resource != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.getModule(resource);
    }

    public IDirectory getDirectoryByPath(IPath path) {
        if (path.segmentCount() == 0) {
            return new LocalDirectory((IContainer)this.project, this);
        }
        IFolder resource = this.project.getFolder(path);
        if (resource == null) {
            return null;
        }
        return this.getDirectory(resource);
    }

    public boolean isPassive() {
        return false;
    }

    public IProject getProject() {
        return this.project;
    }

    public List<IModule> getModulesByPath(IPath path) {
        Object resource = null;
        resource = path.segmentCount() == 0 ? this.project : this.project.getFolder(path);
        if (resource == null || !(resource instanceof IContainer) || !resource.exists()) {
            return null;
        }
        IResource[] innerResources = null;
        try {
            innerResources = ((IContainer)resource).members();
        }
        catch (CoreException e) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error getting modules by path", (Throwable)e, (String)"com.aptana.editor.php/debug");
            return null;
        }
        ArrayList<IFile> innerFiles = new ArrayList<IFile>();
        IResource[] iResourceArray = innerResources;
        int n = innerResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource innerResource = iResourceArray[n2];
            if (innerResource instanceof IFile && ((IFile)innerResource).exists()) {
                innerFiles.add((IFile)innerResource);
            }
            ++n2;
        }
        ArrayList<IModule> result = new ArrayList<IModule>();
        for (IFile innerFile : innerFiles) {
            IModule currentModule = this.getModule(innerFile);
            if (currentModule == null) continue;
            result.add(currentModule);
        }
        return result;
    }

    public List<IDirectory> getSubdirectoriesByPath(IPath path) {
        Object resource = null;
        resource = path.segmentCount() == 0 ? this.project : this.project.getFolder(path);
        if (resource == null || !(resource instanceof IContainer) || !resource.exists()) {
            return null;
        }
        IResource[] innerResources = null;
        try {
            innerResources = ((IContainer)resource).members();
        }
        catch (CoreException e) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error getting sub-directories by path", (Throwable)e, (String)"com.aptana.editor.php/debug");
            return null;
        }
        ArrayList<IFolder> innerFolders = new ArrayList<IFolder>();
        IResource[] iResourceArray = innerResources;
        int n = innerResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource innerResource = iResourceArray[n2];
            if (innerResource instanceof IFolder && ((IFolder)innerResource).exists()) {
                innerFolders.add((IFolder)innerResource);
            }
            ++n2;
        }
        ArrayList<IDirectory> result = new ArrayList<IDirectory>();
        for (IFolder innerFolder : innerFolders) {
            if (!innerFolder.isAccessible()) continue;
            LocalDirectory currentDir = new LocalDirectory((IContainer)innerFolder, this);
            result.add(currentDir);
        }
        return result;
    }

    public boolean contains(IModule module) {
        if (!(module instanceof LocalModule)) {
            return false;
        }
        return this.getModule(((LocalModule)module).getFile()) != null;
    }

    private void bindListeners(IWorkspace workspace) {
        this.workspaceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                ArrayList<IModule> added = new ArrayList<IModule>();
                ArrayList<IModule> changed = new ArrayList<IModule>();
                ArrayList<IModule> removed = new ArrayList<IModule>();
                ArrayList<IDirectory> addedDirectories = new ArrayList<IDirectory>();
                ArrayList<IDirectory> removedDirectories = new ArrayList<IDirectory>();
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    try {
                        delta.accept((IResourceDeltaVisitor)new PHPElementsDeltaVisitor(added, changed, removed, addedDirectories, removedDirectories));
                    }
                    catch (CoreException e) {
                        IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error binding listeners", (Throwable)e, (String)"com.aptana.editor.php/debug");
                    }
                }
                Collection modulesCollection = ProjectBuildPath.this.modules.values();
                Collection directoriesCollection = ProjectBuildPath.this.directories.values();
                if (!(added.isEmpty() && removed.isEmpty() && changed.isEmpty() && addedDirectories.isEmpty() && removedDirectories.isEmpty())) {
                    ProjectBuildPath.this.notifyChangedBefore(changed, removed, removedDirectories);
                    modulesCollection.removeAll(removed);
                    directoriesCollection.removeAll(removedDirectories);
                    for (IModule currentModule : added) {
                        if (!(currentModule instanceof LocalModule)) continue;
                        ProjectBuildPath.this.modules.put(((LocalModule)currentModule).getFile(), currentModule);
                    }
                    for (IDirectory dir : addedDirectories) {
                        if (!(dir instanceof LocalDirectory)) continue;
                        ProjectBuildPath.this.directories.put(((LocalDirectory)dir).getContainer(), dir);
                    }
                    ProjectBuildPath.this.notifyChangedAfter(added, changed, removed, addedDirectories, removedDirectories);
                }
            }
        };
        workspace.addResourceChangeListener(this.workspaceListener);
    }

    private void indexLocalResources() {
        try {
            this.project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    if (!resource.isAccessible()) {
                        return false;
                    }
                    if (resource instanceof IProject && !resource.equals((Object)ProjectBuildPath.this.project)) {
                        return false;
                    }
                    if (!resource.getProject().equals((Object)ProjectBuildPath.this.project)) {
                        return false;
                    }
                    if (resource instanceof IFile) {
                        IModule module = PHPLocalModuleFactory.getModule(resource, ProjectBuildPath.this);
                        if (module != null) {
                            ProjectBuildPath.this.modules.put((IFile)resource, module);
                        }
                    } else if (resource instanceof IFolder) {
                        LocalDirectory dir = new LocalDirectory((IContainer)((IFolder)resource), ProjectBuildPath.this);
                        ProjectBuildPath.this.directories.put((IFolder)resource, dir);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error indexing local resources", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
        }
    }

    public String getHandleIdentifier() {
        return String.valueOf('P') + this.project.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProjectBuildPath) {
            return ((ProjectBuildPath)obj).project.equals((Object)this.project);
        }
        return false;
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    private final class PHPElementsDeltaVisitor
    implements IResourceDeltaVisitor {
        private List<IModule> added;
        private List<IModule> changed;
        private List<IModule> removed;
        private List<IDirectory> addedDirectories;
        private List<IDirectory> removedDirectories;

        private PHPElementsDeltaVisitor(List<IModule> added, List<IModule> changed, List<IModule> removed, List<IDirectory> addedDirectories, List<IDirectory> removedDirectories) {
            this.added = added;
            this.changed = changed;
            this.removed = removed;
            this.addedDirectories = addedDirectories;
            this.removedDirectories = removedDirectories;
        }

        public boolean visit(IResourceDelta delta) {
            block22: {
                IResource resource;
                block21: {
                    resource = delta.getResource();
                    if (!resource.isAccessible() && delta.getKind() != 2) {
                        return false;
                    }
                    if (resource instanceof IProject && !resource.equals((Object)ProjectBuildPath.this.project)) {
                        return false;
                    }
                    if (!(resource instanceof IFile) && !(resource instanceof IFolder)) {
                        return true;
                    }
                    if (!resource.getProject().equals((Object)ProjectBuildPath.this.project)) {
                        return false;
                    }
                    if (delta.getFlags() == 131072) {
                        return false;
                    }
                    if (!(resource instanceof IFile)) break block21;
                    IModule module = null;
                    switch (delta.getKind()) {
                        case 1: {
                            IModule oldModule;
                            IFile fromFile;
                            IPath fromPath;
                            module = PHPLocalModuleFactory.getModule(resource, ProjectBuildPath.this);
                            if (module == null) {
                                return true;
                            }
                            this.added.add(module);
                            if ((delta.getFlags() & 0x1000) != 0 && (fromPath = delta.getMovedFromPath()) != null && (fromFile = resource.getWorkspace().getRoot().getFile(fromPath)) != null && (oldModule = PHPLocalModuleFactory.getModuleUnsafe((IResource)fromFile, ProjectBuildPath.this)) != null) {
                                this.removed.add(oldModule);
                                break;
                            }
                            break block22;
                        }
                        case 4: {
                            module = PHPLocalModuleFactory.getModule(resource, ProjectBuildPath.this);
                            if (module == null) {
                                return true;
                            }
                            this.changed.add(module);
                            break;
                        }
                        case 2: {
                            module = PHPLocalModuleFactory.getModuleUnsafe(resource, ProjectBuildPath.this);
                            if (module != null) {
                                this.removed.add(module);
                                break;
                            }
                            break block22;
                        }
                    }
                    break block22;
                }
                if (resource instanceof IFolder) {
                    if (!resource.isSynchronized(1)) {
                        return true;
                    }
                    if (!FolderFilteringManager.acceptFolder((IFolder)resource)) {
                        return false;
                    }
                    LocalDirectory dir = new LocalDirectory((IContainer)((IFolder)resource), ProjectBuildPath.this);
                    switch (delta.getKind()) {
                        case 1: {
                            this.addedDirectories.add(dir);
                            break;
                        }
                        case 2: {
                            this.removedDirectories.add(dir);
                            break;
                        }
                    }
                }
            }
            return true;
        }
    }
}

